<?php
/**
 * Additional sidebars
 */

class Penci_Custom_Sidebar {

	protected static $initialized = false;

	public static function initialize() {
		if ( self::$initialized ) {
			return;
		}

		add_action( 'wp_ajax_soledad_add_sidebar', array( __CLASS__, 'add_sidebar' ) );
		add_action( 'wp_ajax_soledad_remove_sidebar', array( __CLASS__, 'remove_sidebar' ) );

		add_action( 'init', array( __CLASS__, 'register_sidebars' ) );
		add_action( 'sidebar_admin_page', array( __CLASS__, 'admin_page' ) );

		self::$initialized = true;
	}

	/**
	 * Register sidebars
	 */
	public static function register_sidebars() {

		if ( is_page_template( 'page-templates/full-width.php' ) ) {
			return;
		}

		$sidebars = get_option( 'soledad_custom_sidebars' );

		if ( empty( $sidebars ) ) {
			return;
		}

		foreach ( ( array ) $sidebars as $id => $sidebar ) {
			if ( ! isset( $sidebar['id'] ) ) {
				$sidebar['id'] = $id;
			}

			$sidebar['before_widget'] = '<aside id="%1$s" class="widget %2$s">';
			$sidebar['class'] = 'soledad-custom-sidebar';

			register_sidebar( $sidebar );
		}
	}

	/**
	 * Add sidebar
	 */
	public static function add_sidebar() {

		$name  = isset( $_POST['_nameval'] ) ? $_POST['_nameval'] : '';
		$nonce = isset( $_POST['_wpnonce'] ) ? $_POST['_wpnonce'] : '';

		if ( empty( $nonce ) ) {
			wp_send_json_error( esc_html__( 'Invalid request.', 'soledad' ) );
		} elseif ( empty( $name ) ) {
			wp_send_json_error( esc_html__( 'Missing sidebar name.', 'soledad' ) );
		}

		if ( ! wp_verify_nonce( $nonce, 'ajax-nonce' ) ) {
			wp_send_json_error( esc_html__( 'Nonce verification fails.', 'soledad' ) );
		}

		// Get  custom sidebars.
		$sidebars    = get_option( 'soledad_custom_sidebars', array() );
		$sidebar_num = get_option( 'soledad_custom_sidebars_lastid', - 1 );

		if ( $sidebar_num < 0 ) {
			$sidebar_num = 0;
			if ( is_array( $sidebars ) ) {
				$key_sidebars = explode( '-', end( array_keys( $sidebars ) ) );
				$sidebar_num  = ( int ) end( $key_sidebars );
			}
		}

		update_option( 'soledad_custom_sidebars_lastid', ++ $sidebar_num );

		$sidebars[ 'soledad-custom-sidebar-' . $sidebar_num ] = array(
			'id'            => 'soledad-custom-sidebar-' . $sidebar_num,
			'name'          => stripcslashes( $name ),
			'description'   => '',
			'before_widget' => '<aside id="%1$s" class="widget %2$s">',
			'after_widget'  => '</aside>',
			'before_title'  => '<h4 class="widget-title penci-border-arrow"><span class="inner-arrow">',
			'after_title'   => '</span></h4>',
		);

		update_option( 'soledad_custom_sidebars', $sidebars );

		if ( ! function_exists( 'wp_list_widget_controls' ) ) {
			include_once ABSPATH . 'wp-admin/includes/widgets.php';
		}

		ob_start();
		?>
		<div class="widgets-holder-wrap sidebar-soledad-custom-sidebar closed">
			<?php wp_list_widget_controls( 'soledad-custom-sidebar-' . $sidebar_num, stripcslashes( $name ) ); ?>
		</div>
		<?php
		$output = ob_get_clean();

		wp_send_json_success( $output );
	}

	/**
	 * Remove sidebar
	 */
	public static function remove_sidebar() {

		$idSidebar = isset( $_POST['idSidebar'] ) ? $_POST['idSidebar'] : '';
		$nonce     = isset( $_POST['_wpnonce'] ) ? $_POST['_wpnonce'] : '';

		if ( empty( $nonce ) ) {
			wp_send_json_error( esc_html__( 'Invalid request.', 'soledad' ) );
		} elseif ( empty( $idSidebar ) ) {
			wp_send_json_error( esc_html__( 'Missing sidebar ID', 'soledad' ) );
		}

		if ( ! wp_verify_nonce( $nonce, 'ajax-nonce' ) ) {
			wp_send_json_error( esc_html__( 'Nonce verification fails.', 'soledad' ) );
		}

		$custom_sidebars = get_option( 'soledad_custom_sidebars', array() );

		unset( $custom_sidebars[ $idSidebar ] );

		update_option( 'soledad_custom_sidebars', $custom_sidebars );

		wp_send_json_success();
	}

	/**
	 * Print HTML code to manage custom sidebar
	 */
	public static function admin_page() {
		global $wp_registered_sidebars;
		?>
		<div class="widgets-holder-wrap">
			<div id="penci-add-custom-sidebar" class="widgets-sortables">
				<div class="sidebar-name">
					<div class="sidebar-name-arrow"><br></div>
					<h2>
						<?php esc_html_e( 'Add New Sidebar', 'soledad' ); ?>
						<span class="spinner"></span>
					</h2>
				</div>
				<div class="sidebar-description">
					<form class="description" method="POST" action="">
						<?php wp_nonce_field( 'soledad_add_sidebar' ); ?>
						<table class="form-table">
							<tr valign="top">
								<td>
									<input id="penci-add-custom-sidebar-name" style="width: 100%;" type="text" class="text" name="name" value="" placeholder="<?php esc_attr_e( 'Enter sidebar name', 'soledad' ) ?>">
								</td>
								<td>
									<input type="submit" class="button-primary" value="<?php esc_attr_e( 'Add', 'soledad' ) ?>">
								</td>
							</tr>
						</table>
					</form>
				</div>
			</div>
		</div>
		<style type="text/css" media="screen">
			.soledad-remove-custom-sidebar .notice-dismiss {
				right: 30px;
				top: 3px;
			}
		</style>
		<?php
	}

	public static function get_list_sidebar( $selected ) {
		$custom_sidebars = get_option( 'soledad_custom_sidebars' );

		if ( empty( $custom_sidebars ) || ! is_array( $custom_sidebars ) ) {
			return '';
		}

		foreach ( $custom_sidebars as $sidebar_id => $custom_sidebar ) {

			if ( empty( $custom_sidebar['name'] ) ) {
				continue;
			}
			?>
			<option value="<?php echo esc_attr( $sidebar_id ); ?>" <?php selected( $selected, $sidebar_id ); ?>><?php echo $custom_sidebar['name']; ?></option>
			<?php
		}
	}

	public static function get_list_sidebar_el() {
		$custom_sidebars = get_option( 'soledad_custom_sidebars' );

		$list_sidebar = array(
			'main-sidebar'      => esc_html__( 'Main Sidebar', 'soledad' ),
			'custom-sidebar-1'  => esc_html__( 'Custom Sidebar 1', 'soledad' ),
			'custom-sidebar-2'  => esc_html__( 'Custom Sidebar 2', 'soledad' ),
			'custom-sidebar-3'  => esc_html__( 'Custom Sidebar 3', 'soledad' ),
			'custom-sidebar-4'  => esc_html__( 'Custom Sidebar 4', 'soledad' ),
			'custom-sidebar-5'  => esc_html__( 'Custom Sidebar 5', 'soledad' ),
			'custom-sidebar-6'  => esc_html__( 'Custom Sidebar 6', 'soledad' ),
			'custom-sidebar-7'  => esc_html__( 'Custom Sidebar 7', 'soledad' ),
			'custom-sidebar-8'  => esc_html__( 'Custom Sidebar 8', 'soledad' ),
			'custom-sidebar-9'  => esc_html__( 'Custom Sidebar 9', 'soledad' ),
			'custom-sidebar-10' => esc_html__( 'Custom Sidebar 10', 'soledad' )
		);

		if ( empty( $custom_sidebars ) || ! is_array( $custom_sidebars ) ) {
			return $list_sidebar;
		}

		foreach ( $custom_sidebars as $sidebar_id => $custom_sidebar ) {

			if ( empty( $custom_sidebar['name'] ) ) {
				continue;
			}
			$list_sidebar[ $sidebar_id ] = $custom_sidebar['name'];
		}

		return $list_sidebar;
	}

	public static function get_list_sidebar_vc() {
		$custom_sidebars = get_option( 'soledad_custom_sidebars' );

		$list_sidebar = array(
			'Main Sidebar'      => 'main-sidebar',
			'Custom Sidebar 1'  => 'custom-sidebar-1',
			'Custom Sidebar 2'  => 'custom-sidebar-2',
			'Custom Sidebar 3'  => 'custom-sidebar-3',
			'Custom Sidebar 4'  => 'custom-sidebar-4',
			'Custom Sidebar 5'  => 'custom-sidebar-5',
			'Custom Sidebar 6'  => 'custom-sidebar-6',
			'Custom Sidebar 7'  => 'custom-sidebar-7',
			'Custom Sidebar 8'  => 'custom-sidebar-8',
			'Custom Sidebar 9'  => 'custom-sidebar-9',
			'Custom Sidebar 10' => 'custom-sidebar-10'
		);

		if ( empty( $custom_sidebars ) || ! is_array( $custom_sidebars ) ) {
			return $list_sidebar;
		}

		foreach ( $custom_sidebars as $sidebar_id => $custom_sidebar ) {

			if ( empty( $custom_sidebar['name'] ) ) {
				continue;
			}
			$list_sidebar[ esc_html( $custom_sidebar['name'] ) ] = $sidebar_id;
		}

		return $list_sidebar;
	}
}

Penci_Custom_Sidebar::initialize();